/**
* \file: helper.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#include <string.h>
#include <stdbool.h>
#include <stdlib.h>

#include "utils/helper.h"

void helper_strcrplc(char *string, const char find_char, const char rplc_char, size_t max_len)
{
	while (*string!='\0' && max_len != 0)
	{
		if (*string==find_char)
			*string=rplc_char;
		string++;
		max_len--;
	}
}

bool helper_does_string_contain_token(const char *string, const char *token_to_find, const char *delimiters)
{
	bool result=false;

	char *copy_str;
	char *token;

	copy_str=strdup(string);
	if (copy_str==NULL)
		return false;

	token=strtok(copy_str, delimiters);
	while (!result && token != NULL)
	{
		result=strcmp(token, token_to_find)==0;
		token=strtok(NULL,delimiters);
	}

	free(copy_str);

	return result;
}

char *helper_trim(char *string, bool *is_empty)
{
	size_t len;
	char* p_begin;
	char* p_end;

	len=strlen(string);

	p_begin=string;
	//end points to the character before the terminating '\0'
	p_end=string+len-1;

	//remove leading spaces
	//each string is terminated by '\0' so this loop will end
	while((*p_begin)==' ')
		p_begin++;

	//remove trailing spaces or new lines
	while (p_end >= p_begin && ((*p_end)=='\n' || (*p_end)==' '))
	{
		(*p_end)='\0';
		p_end--;
	}

	if (is_empty!=NULL)
		*is_empty=(*p_begin)=='\0';

	return p_begin;
}
